//+------------------------------------------------------------------+
//|                              Momentum Candles Modified w atr.mq4 |
//|                                             nielsindicatorcoding |
//|                                   nielsindicatorcoding@gmail.com |
//+------------------------------------------------------------------+
#property copyright "nielsindicatorcoding"
#property link      "mailto:nielsindicatorcoding@gmail.com"
#property version   "1.00"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_plots 3
//--- plot Linea1
#property indicator_label1 "Value"
#property indicator_label2 "Treshhold+"
#property indicator_label3 "Treshhold-"

//--- indicator buffers
double Value[];
double Tresh1[];
double Tresh2[];
// ------------------------------------------------------------------
input double    atr_multiplier = 2.5;                 

//+------------------------------------------------------------------+
int OnInit()
{
   //--- indicator buffers mapping
   SetIndexBuffer(0, Value, INDICATOR_DATA);
   SetIndexStyle(0, DRAW_LINE, EMPTY, 3, clrYellow);
   SetIndexBuffer(1, Tresh1, INDICATOR_DATA);
   SetIndexStyle(1, DRAW_LINE, EMPTY, 3, clrGreen);
   
   SetIndexBuffer(2, Tresh2, INDICATOR_DATA);
   SetIndexStyle(2, DRAW_LINE, EMPTY, 3, clrRed);
   // SetIndexStyle(0, DRAW_NONE);
   // SetIndexStyle(1, DRAW_NONE);
   //---
   return (INIT_SUCCEEDED);
}
int OnCalculate(const int       rates_total,
                const int       prev_calculated,
                const datetime& time[],
                const double&   open[],
                const double&   high[],
                const double&   low[],
                const double&   close[],
                const long&     tick_volume[],
                const long&     volume[],
                const int&      spread[])
{

   int i;
      
   for(i=Bars-50; i>=0; i--)
   {
      Value[i] = (Close[i]-Open[i])/iATR(NULL,NULL,50,i);
      Tresh1[i] = 1/atr_multiplier ;
      Tresh2[i] = -1/atr_multiplier ;
   }

   return (rates_total);
}
